/** @file pd_lang_k.h  Test class to derive strings from pushdown automata */


/* Pushdown plugin for FAU Discrete Event Systems Library (libfaudes)

   Copyright (C) 2013  Stefan Jacobi, Sven Schneider, Anne-Kathrin Hess

*/


#ifndef FAUDES_PD_LANG_K_H
#define FAUDES_PD_LANG_K_H

#include "corefaudes.h"
#include "pd_include.h"


namespace faudes {
 
  
/**
* This class is used to find all words that can be found when traversing a maximum of
* k transitions of a given generator. It is intended mainly for debugging purposes, 
* not for finding whole languages.
* 
* Note: length k can include "empty" (lambda) strings
* 
*
* 
*
* @ingroup PushdownPlugin
* 
* @section Overview
*  Overview
* 
* @section Contents
*  Contents
*/
  
class FAUDES_API LangK{
  
  public:
    
  /**
   * Constructor
   * 
   * @param gen
   *    the generator 
   */
  LangK(const PushdownGenerator& gen) : pd(gen) {};
  
  /**
   * find all words that can be generated by traversing k transitions
   * 
   * @param k
   *    number of transitions to traverse
   * @param showStack
   *    show stack while traversing, defaults to false
   */
  std::set<std::string> FindLangK(uint k, bool showStack = false);
  
  /**
   * Print the words that were found in the last execution of FindLangK
   */
  void PrintWords();
  
  private:
  
  /** storage for the words*/
  std::set<std::string> words;
  /** the generator*/
  const PushdownGenerator pd;
  /** maximum word length*/
  uint k;
  
  /**
   * Recursively traverse the generator and build new words until word length is k.
   * 
   * @param i
   *    Index of the current state
   * @param word
   *    current word
   * @param stack
   *    current stack
   * @param depth
   *    current length
   * @param showStack
   *    indicator whether to print the stack or not
   */
  void Traverse(Idx i, std::string word, std::vector<Idx> stack, uint depth, bool showStack);
  
};

} // namespace faudes

#endif
