/** @file pd_alg_opt_test.h  Unit Tests */


/* Pushdown plugin for FAU Discrete Event Systems Library (libfaudes)

   Copyright (C) 2013  Stefan Jacobi, Sven Schneider, Anne-Kathrin Hess

*/

#ifndef FAUDES_PD_ALG_OPT_TEST_H
#define FAUDES_PD_ALG_OPT_TEST_H

#include "corefaudes.h"
#include "pd_include.h"
#include "pd_test_util.h"

namespace faudes {

/**
 * Test if RemoveUselessTransitions removes the correct amount of transitions from a
 * test generator.
 */
void TestRemoveUselessTransitionsNumberOfTransitions();

/**
 * Test if GetPossibleStackTops finds the correct stack symbols
 */
void TestGetPossibleStackTopsFindCorrectOnes();

/**
 * all RemoveUselessTransitions tests
 */
void TestRemoveUselessTransitions();

/**
 * all GetPossibleStackTops tests
 */
void TestGetPossibleStackTops();

} // namespace faudes

#endif