/** @file pd_alg_nb_sub_a_test.h  Unit Tests */


/* Pushdown plugin for FAU Discrete Event Systems Library (libfaudes)

   Copyright (C) 2013  Stefan Jacobi, Sven Schneider, Anne-Kathrin Hess

*/

#ifndef FAUDES_PD_ALG_NB_SUB_A_TEST_H
#define FAUDES_PD_ALG_NB_SUB_A_TEST_H

#include "corefaudes.h"
#include "pd_include.h"
#include "pd_test_util.h"

namespace faudes {

/**
 * Filter a nonterminal from a vector of terminals and nonterminals.
 */
void TestFilterMixedGrammarSymbols();

/**
 * filter from an empty word
 */
void TestFilterNothing();

/**
 * Find an eliminable symbol with Rnpp1 and an empty set of nonterminals
 */
void TestRnpp1FindSymbolsEmptySet();

/**
 * Find an eliminable symbol with Rnpp1 and a nonempty set of nonterminals
 */
void TestRnpp1FindSymbolsNonemptySet();

/**
 * Find all eliminable symbols with Rnppl and an empty set of nonterminals
 */
void TestRnpplFindSymbolsEmptySet();

/**
 * Find all eliminable symbolswith Rnppl and a nonempty set of nonterminals
 */
void TestRnpplFindSymbolsNonemptySet();

/**
 * Find all eliminable symbols with Rnppl and a set already containing all
 * eliminable symbols
 */
void TestRnpplFindSymbolsCompleteSet();

/**
 * Remove all noneliminable nonterminals and all productions containing
 * noneliminable nonterminals
 */
void TestRnppGrammar1();

/**
 * Remove all noneliminable nonterminals and all productions containing
 * noneliminable nonterminals
 */
void TestRnppGrammar2();

/**
 * Try to remove all noneliminable nonterminals and all productions containing
 * noneliminable nonterminals from an empty grammar.
 */
void TestRnppEmptyGrammar();

/**
 * Test if all terminals have been set correctly and match the generator's events.
 */ 
void TestSp2LrTerminals();

/**
 * Test if all possible nonterminals were generated.
 */
void TestSp2LrNonterminals();

/**
 * Test if all expected productions for read, pop and push transitions and for the final 
 * states were generated.
 */
void TestSp2LrProductions();

/**
 * Test if all expected productions for read, pop and push transitions and for the final 
 * states were generated.
 */
void TestSp2Lr2Productions();

/**
 * 
 */
void TestRupProductions();

/**
 * 
 */
void TestRupNonterminals();

/**
 * All Filter tests
 */
void TestFilter();

/**
 * All Rnpp1 tests
 */
void TestRnpp1();

/**
 * All Rnppl tests
 */
void TestRnppl();

/**
 * All Rnpp tests
 */
void TestRnpp();

/**
 * All Sp2Lr tests
 */
void TestSp2Lr();

/**
 * All Sp2Lr tests
 */
void TestSp2Lr2();

/**
 * All Rup tests
 */
void TestRup();

} // namespace faudes

#endif