/** 

@file pd_interface.i 

SWIG interface for pushdown plugin.
**/


/*
**************************************************
**************************************************
**************************************************

Pushdown interface preface

**************************************************
**************************************************
**************************************************
*/

// Set SWIG module name
// Note: must match libFAUDES plugin name
%module pushdown


// Indicate plugin to rti function definitions
#ifndef SwigModule
#define SwigModule "SwigPushdown"
#endif

// Load std faudes interface
%include "faudesmodule.i"

// Extra Lua functions: copy to faudes name space
%luacode {
-- Copy pushdown to faudes name space
for k,v in pairs(pushdown) do faudes[k]=v end
}


/*
**************************************************
**************************************************
**************************************************

Pushdown interface: plugin data types

**************************************************
**************************************************
**************************************************
*/


class PushdownGenerator : public Type {
public:
  // construct/destruct/maintenance
  PushdownGenerator(void);
  PushdownGenerator(const PushdownGenerator& rOther);
  PushdownGenerator(const Generator& rOther);
  PushdownGenerator(const std::string& rFilename);
  virtual ~PushdownGenerator();
  // file IO inherited from faudes:Type
};




// Include rti generated functioninterface 
#if SwigModule=="SwigPushdown"
%include "../../../include/rtiautoload.i"
#endif
