/** @file pd_alg_opt.h  functions for optimizations*/


/* Pushdown plugin for FAU Discrete Event Systems Library (libfaudes)

   Copyright (C) 2013  Stefan Jacobi, Sven Schneider, Anne-Kathrin Hess

*/


#ifndef FAUDES_PD_ALG_OPT_H
#define FAUDES_PD_ALG_OPT_H

#include "corefaudes.h"
#include "pd_pdgenerator.h"

namespace faudes {
  
   /**
   * Delete stack symbols from the generator that are not used in any of the transitions
   * 
   * @param pd
   *    pushdown generator to trim
   * @return
   *    trimmed pushdown generator
   */
  PushdownGenerator TrimStackSymbols(const PushdownGenerator& pd);
  
   /**
   * Remove certain transitions that can never be used because their pop symbol can never
   * be the stack top.
   * 
   * @param pd
   *    the generator from which to remove transitions
   * @return
   *    generator with removed transitions
   */
  PushdownGenerator RemoveUselessTransitions(const PushdownGenerator& pd);
  
  /**
   * Get all possible stack top symbols for a state.
   * 
   * @param pd
   *    the pushdown generator containing the state
   * @param examinedStates
   *    the already examined states
   * @param q
   *    the state
   * @return
   *    set of all possible stack top symbols
   */
  StackSymbolSet GetPossibleStackTops(const PushdownGenerator& pd, const StateSet& examinedStates, Idx q);



} // namespace faudes

#endif
