/** @file pd_alg_nb_sub_a.h  Nonblock subfunctions, part A*/


/* Pushdown plugin for FAU Discrete Event Systems Library (libfaudes)

   Copyright (C) 2013  Stefan Jacobi, Sven Schneider, Anne-Kathrin Hess

*/


#ifndef FAUDES_PD_ALG_NB_SUB_A_H
#define FAUDES_PD_ALG_NB_SUB_A_H

#include "corefaudes.h"
#include "pd_pdgenerator.h"


namespace faudes {
  
  /**
   * Extract all symbols from the word that are in the symbol set
   * 
   * @param symbolSet
   *    the  symbol set
   * @param w
   *    the word
   * @return
   *    set of found symbols
   */
  std::set<Nonterminal> Filter(const std::set<Nonterminal>& symbolSet, const GrammarSymbolVector& w);
  
  /**
   * Find all nonterminals that are eliminable in one step and assuming that a certain 
   * set of nonterminals has already been eliminated.
   * 
   * @param gr
   *    the grammar
   * @param ntSet
   *    the set of already eliminated nonterminals
   * @return
   *    eliminable symbols including the already eliminated ones
   */
  std::set<Nonterminal> Rnpp1(const Grammar& gr, const std::set<Nonterminal>& ntSet);
  
  /**
   * Find all nonterminals that are eliminable in as many steps as needed and assuming 
   * that a certain set of nonterminals has already been eliminated.
   * 
   * @param gr
   *    the grammar
   * @param ntSet
   *    the set of already eliminated nonterminals
   * @return
   *    eliminable symbols including the already eliminated ones
   */
  std::set<Nonterminal> Rnppl(const Grammar& gr, const std::set<Nonterminal>& ntSet);
  
  /**
   * Remove all productions from a grammar that are nonproductive, i. e. they 
   * contain nonterminals that are not eliminable.
   */
  Grammar Rnpp(const Grammar& gr);
  
  /**
   * Transform a simple pushdown generator into an LR(1) grammar.
   * 
   * @param pd
   *    the generator
   * @return
   *    the grammar
   */
  Grammar Sp2Lr(const PushdownGenerator& pd);
  
  /**
   * Transform a simple pushdown generator into an LR(1) grammar. Memory-optimized version.
   * May take significantly longer than the non-optimized version.
   * 
   * @param pd
   *    the generator
   * @return
   *    the grammar
   */
  Grammar Sp2Lr2(const PushdownGenerator& pd);
  
  /**
   * Remove all unreachable productions and nonterminals from the grammar
   * 
   * @param gr
   *    grammar with productions to be removed
   * @return
   *    grammar with only reachable productions
   */
  Grammar Rup(const Grammar& gr);

} // namespace faudes

#endif
