/** @file hio_include.h Include hiosys plugin headers */

/*
 **************************************************** 
 Convenience header file that includes all headers 
 relevant to the hiosys plugin. To use the plugin for
 other projects just include this convenience header.

 (c) Sebastian Perk, Thomas Moor, Klaus Schmidt 2008
 ****************************************************
 */

#ifndef FAUDES_HIO_INCLUDE_H
#define FAUDES_HIO_INCLUDE_H

#include "hio_constraint.h"
#include "hio_plant.h"
#include "hio_controller.h"
#include "hio_environment.h"
#include "hio_functions.h"

#endif

/** 

@defgroup hiosysplugin Hierarchical I/O Systems Plug-In

@ingroup AllPlugins

@section HioOverview Overview

<p>
This plugin implements data types and functions related to the input-/output
 (I/O-) based approach to hierarchical control of discrete event systems as
 introduced in:
</p>

<p><i>
S. Perk, Th. Moor and K. Schmidt. Hierarchical discrete event systems
with inputs and outputs. WODES 2006 - 8th International Workshop on Discrete
Event Systems, Ann Arbor, USA, 2006.
</i></p>

<p>
Examples are provided in the user reference, 
section <a href="../reference/hiosys_index.html">HioSys</a>.
</p>

@section HioLicense License

<p>
This plug-in is distributed with libFAUDES and under the terms of the LGPL. <br>
 <br>
 Copyright (c) 2009, Thomas Moor, Sebastian Perk, Klaus Schmidt.
</p>

@section Contents

*/
